package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CellSignals(
    lteCellDetails: Iterable[zio.aws.location.model.LteCellDetails]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CellSignals = {
    import CellSignals.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CellSignals
      .builder()
      .lteCellDetails(lteCellDetails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CellSignals.ReadOnly =
    zio.aws.location.model.CellSignals.wrap(buildAwsValue())
}
object CellSignals {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CellSignals
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CellSignals =
      zio.aws.location.model.CellSignals(lteCellDetails.map { item =>
        item.asEditable
      })
    def lteCellDetails: List[zio.aws.location.model.LteCellDetails.ReadOnly]
    def getLteCellDetails: ZIO[Any, Nothing, List[
      zio.aws.location.model.LteCellDetails.ReadOnly
    ]] = ZIO.succeed(lteCellDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CellSignals
  ) extends zio.aws.location.model.CellSignals.ReadOnly {
    override val lteCellDetails
        : List[zio.aws.location.model.LteCellDetails.ReadOnly] = impl
      .lteCellDetails()
      .asScala
      .map { item =>
        zio.aws.location.model.LteCellDetails.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CellSignals
  ): zio.aws.location.model.CellSignals.ReadOnly = new Wrapper(impl)
}
