package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Circle(center: Iterable[Double], radius: Double) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Circle = {
    import Circle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Circle
      .builder()
      .center(center.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .radius(radius: java.lang.Double)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Circle.ReadOnly =
    zio.aws.location.model.Circle.wrap(buildAwsValue())
}
object Circle {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Circle] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Circle =
      zio.aws.location.model.Circle(center, radius)
    def center: List[Double]
    def radius: Double
    def getCenter: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(center)
    def getRadius: ZIO[Any, Nothing, Double] = ZIO.succeed(radius)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Circle
  ) extends zio.aws.location.model.Circle.ReadOnly {
    override val center: List[Double] = impl
      .center()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val radius: Double = impl.radius(): Double
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Circle
  ): zio.aws.location.model.Circle.ReadOnly = new Wrapper(impl)
}
