package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ResourceDescription,
  TagValue,
  KmsKeyId,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateGeofenceCollectionRequest(
    collectionName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest = {
    import CreateGeofenceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.CreateGeofenceCollectionRequest.ReadOnly =
    zio.aws.location.model.CreateGeofenceCollectionRequest.wrap(buildAwsValue())
}
object CreateGeofenceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateGeofenceCollectionRequest =
      zio.aws.location.model.CreateGeofenceCollectionRequest(
        collectionName,
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        description.map(value => value),
        tags.map(value => value),
        kmsKeyId.map(value => value)
      )
    def collectionName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Optional[String]
    def description: Optional[ResourceDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def kmsKeyId: Optional[KmsKeyId]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
  ) extends zio.aws.location.model.CreateGeofenceCollectionRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateGeofenceCollectionRequest
  ): zio.aws.location.model.CreateGeofenceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
