package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateKeyRequest(
    keyName: ResourceName,
    restrictions: zio.aws.location.model.ApiKeyRestrictions,
    description: Optional[ResourceDescription] = Optional.Absent,
    expireTime: Optional[Timestamp] = Optional.Absent,
    noExpiry: Optional[Boolean] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateKeyRequest = {
    import CreateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateKeyRequest
      .builder()
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .restrictions(restrictions.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        expireTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expireTime)
      .optionallyWith(noExpiry.map(value => value: java.lang.Boolean))(
        _.noExpiry
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateKeyRequest.ReadOnly =
    zio.aws.location.model.CreateKeyRequest.wrap(buildAwsValue())
}
object CreateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateKeyRequest =
      zio.aws.location.model.CreateKeyRequest(
        keyName,
        restrictions.asEditable,
        description.map(value => value),
        expireTime.map(value => value),
        noExpiry.map(value => value),
        tags.map(value => value)
      )
    def keyName: ResourceName
    def restrictions: zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    def description: Optional[ResourceDescription]
    def expireTime: Optional[Timestamp]
    def noExpiry: Optional[Boolean]
    def tags: Optional[Map[TagKey, TagValue]]
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getRestrictions: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    ] = ZIO.succeed(restrictions)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getExpireTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expireTime", expireTime)
    def getNoExpiry: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("noExpiry", noExpiry)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateKeyRequest
  ) extends zio.aws.location.model.CreateKeyRequest.ReadOnly {
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val restrictions
        : zio.aws.location.model.ApiKeyRestrictions.ReadOnly =
      zio.aws.location.model.ApiKeyRestrictions.wrap(impl.restrictions())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val expireTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expireTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val noExpiry: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.noExpiry())
      .map(value => value: Boolean)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateKeyRequest
  ): zio.aws.location.model.CreateKeyRequest.ReadOnly = new Wrapper(impl)
}
