package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn, ApiKey}
import scala.jdk.CollectionConverters._
final case class CreateKeyResponse(
    key: ApiKey,
    keyArn: Arn,
    keyName: ResourceName,
    createTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateKeyResponse = {
    import CreateKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateKeyResponse
      .builder()
      .key(ApiKey.unwrap(key): java.lang.String)
      .keyArn(Arn.unwrap(keyArn): java.lang.String)
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateKeyResponse.ReadOnly =
    zio.aws.location.model.CreateKeyResponse.wrap(buildAwsValue())
}
object CreateKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateKeyResponse =
      zio.aws.location.model.CreateKeyResponse(key, keyArn, keyName, createTime)
    def key: ApiKey
    def keyArn: Arn
    def keyName: ResourceName
    def createTime: Timestamp
    def getKey: ZIO[Any, Nothing, ApiKey] = ZIO.succeed(key)
    def getKeyArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(keyArn)
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateKeyResponse
  ) extends zio.aws.location.model.CreateKeyResponse.ReadOnly {
    override val key: ApiKey =
      zio.aws.location.model.primitives.ApiKey(impl.key())
    override val keyArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.keyArn())
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateKeyResponse
  ): zio.aws.location.model.CreateKeyResponse.ReadOnly = new Wrapper(impl)
}
