package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  TagValue,
  TagKey,
  ResourceDescription,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class CreateMapRequest(
    mapName: ResourceName,
    configuration: zio.aws.location.model.MapConfiguration,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateMapRequest = {
    import CreateMapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateMapRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .configuration(configuration.buildAwsValue())
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateMapRequest.ReadOnly =
    zio.aws.location.model.CreateMapRequest.wrap(buildAwsValue())
}
object CreateMapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateMapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateMapRequest =
      zio.aws.location.model.CreateMapRequest(
        mapName,
        configuration.asEditable,
        pricingPlan.map(value => value),
        description.map(value => value),
        tags.map(value => value)
      )
    def mapName: ResourceName
    def configuration: zio.aws.location.model.MapConfiguration.ReadOnly
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def description: Optional[ResourceDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.location.model.MapConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateMapRequest
  ) extends zio.aws.location.model.CreateMapRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val configuration
        : zio.aws.location.model.MapConfiguration.ReadOnly =
      zio.aws.location.model.MapConfiguration.wrap(impl.configuration())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateMapRequest
  ): zio.aws.location.model.CreateMapRequest.ReadOnly = new Wrapper(impl)
}
