package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  TagValue,
  TagKey,
  ResourceDescription,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class CreatePlaceIndexRequest(
    indexName: ResourceName,
    dataSource: String,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    dataSourceConfiguration: Optional[
      zio.aws.location.model.DataSourceConfiguration
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest = {
    import CreatePlaceIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        dataSourceConfiguration.map(value => value.buildAwsValue())
      )(_.dataSourceConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreatePlaceIndexRequest.ReadOnly =
    zio.aws.location.model.CreatePlaceIndexRequest.wrap(buildAwsValue())
}
object CreatePlaceIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreatePlaceIndexRequest =
      zio.aws.location.model.CreatePlaceIndexRequest(
        indexName,
        dataSource,
        pricingPlan.map(value => value),
        description.map(value => value),
        dataSourceConfiguration.map(value => value.asEditable),
        tags.map(value => value)
      )
    def indexName: ResourceName
    def dataSource: String
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def description: Optional[ResourceDescription]
    def dataSourceConfiguration
        : Optional[zio.aws.location.model.DataSourceConfiguration.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getDataSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSourceConfiguration",
      dataSourceConfiguration
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
  ) extends zio.aws.location.model.CreatePlaceIndexRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val dataSource: String = impl.dataSource(): String
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val dataSourceConfiguration
        : Optional[zio.aws.location.model.DataSourceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSourceConfiguration())
        .map(value =>
          zio.aws.location.model.DataSourceConfiguration.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreatePlaceIndexRequest
  ): zio.aws.location.model.CreatePlaceIndexRequest.ReadOnly = new Wrapper(impl)
}
