package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ResourceDescription,
  TagValue,
  KmsKeyId,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateTrackerRequest(
    trackerName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    positionFiltering: Optional[zio.aws.location.model.PositionFiltering] =
      Optional.Absent,
    eventBridgeEnabled: Optional[Boolean] = Optional.Absent,
    kmsKeyEnableGeospatialQueries: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateTrackerRequest = {
    import CreateTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateTrackerRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(positionFiltering.map(value => value.unwrap))(
        _.positionFiltering
      )
      .optionallyWith(
        eventBridgeEnabled.map(value => value: java.lang.Boolean)
      )(_.eventBridgeEnabled)
      .optionallyWith(
        kmsKeyEnableGeospatialQueries.map(value => value: java.lang.Boolean)
      )(_.kmsKeyEnableGeospatialQueries)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateTrackerRequest.ReadOnly =
    zio.aws.location.model.CreateTrackerRequest.wrap(buildAwsValue())
}
object CreateTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateTrackerRequest =
      zio.aws.location.model.CreateTrackerRequest(
        trackerName,
        pricingPlan.map(value => value),
        kmsKeyId.map(value => value),
        pricingPlanDataSource.map(value => value),
        description.map(value => value),
        tags.map(value => value),
        positionFiltering.map(value => value),
        eventBridgeEnabled.map(value => value),
        kmsKeyEnableGeospatialQueries.map(value => value)
      )
    def trackerName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def kmsKeyId: Optional[KmsKeyId]
    def pricingPlanDataSource: Optional[String]
    def description: Optional[ResourceDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def positionFiltering: Optional[zio.aws.location.model.PositionFiltering]
    def eventBridgeEnabled: Optional[Boolean]
    def kmsKeyEnableGeospatialQueries: Optional[Boolean]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPositionFiltering
        : ZIO[Any, AwsError, zio.aws.location.model.PositionFiltering] =
      AwsError.unwrapOptionField("positionFiltering", positionFiltering)
    def getEventBridgeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("eventBridgeEnabled", eventBridgeEnabled)
    def getKmsKeyEnableGeospatialQueries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "kmsKeyEnableGeospatialQueries",
        kmsKeyEnableGeospatialQueries
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateTrackerRequest
  ) extends zio.aws.location.model.CreateTrackerRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val positionFiltering
        : Optional[zio.aws.location.model.PositionFiltering] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionFiltering())
        .map(value => zio.aws.location.model.PositionFiltering.wrap(value))
    override val eventBridgeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBridgeEnabled())
      .map(value => value: Boolean)
    override val kmsKeyEnableGeospatialQueries: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyEnableGeospatialQueries())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateTrackerRequest
  ): zio.aws.location.model.CreateTrackerRequest.ReadOnly = new Wrapper(impl)
}
