package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, Arn, ResourceName}
import scala.jdk.CollectionConverters._
final case class CreateTrackerResponse(
    trackerName: ResourceName,
    trackerArn: Arn,
    createTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateTrackerResponse = {
    import CreateTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateTrackerResponse
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .trackerArn(Arn.unwrap(trackerArn): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateTrackerResponse.ReadOnly =
    zio.aws.location.model.CreateTrackerResponse.wrap(buildAwsValue())
}
object CreateTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateTrackerResponse =
      zio.aws.location.model
        .CreateTrackerResponse(trackerName, trackerArn, createTime)
    def trackerName: ResourceName
    def trackerArn: Arn
    def createTime: Timestamp
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getTrackerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(trackerArn)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateTrackerResponse
  ) extends zio.aws.location.model.CreateTrackerResponse.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val trackerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.trackerArn())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateTrackerResponse
  ): zio.aws.location.model.CreateTrackerResponse.ReadOnly = new Wrapper(impl)
}
