package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteKeyRequest(
    keyName: ResourceName,
    forceDelete: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeleteKeyRequest = {
    import DeleteKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeleteKeyRequest
      .builder()
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeleteKeyRequest.ReadOnly =
    zio.aws.location.model.DeleteKeyRequest.wrap(buildAwsValue())
}
object DeleteKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeleteKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeleteKeyRequest =
      zio.aws.location.model
        .DeleteKeyRequest(keyName, forceDelete.map(value => value))
    def keyName: ResourceName
    def forceDelete: Optional[Boolean]
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeleteKeyRequest
  ) extends zio.aws.location.model.DeleteKeyRequest.ReadOnly {
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeleteKeyRequest
  ): zio.aws.location.model.DeleteKeyRequest.ReadOnly = new Wrapper(impl)
}
