package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeletePlaceIndexRequest(indexName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest = {
    import DeletePlaceIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeletePlaceIndexRequest.ReadOnly =
    zio.aws.location.model.DeletePlaceIndexRequest.wrap(buildAwsValue())
}
object DeletePlaceIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeletePlaceIndexRequest =
      zio.aws.location.model.DeletePlaceIndexRequest(indexName)
    def indexName: ResourceName
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest
  ) extends zio.aws.location.model.DeletePlaceIndexRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeletePlaceIndexRequest
  ): zio.aws.location.model.DeletePlaceIndexRequest.ReadOnly = new Wrapper(impl)
}
