package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteTrackerRequest(trackerName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeleteTrackerRequest = {
    import DeleteTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeleteTrackerRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeleteTrackerRequest.ReadOnly =
    zio.aws.location.model.DeleteTrackerRequest.wrap(buildAwsValue())
}
object DeleteTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeleteTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeleteTrackerRequest =
      zio.aws.location.model.DeleteTrackerRequest(trackerName)
    def trackerName: ResourceName
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeleteTrackerRequest
  ) extends zio.aws.location.model.DeleteTrackerRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeleteTrackerRequest
  ): zio.aws.location.model.DeleteTrackerRequest.ReadOnly = new Wrapper(impl)
}
