package zio.aws.location.model
import zio.aws.location.model.primitives.{
  DescribeGeofenceCollectionResponseGeofenceCountInteger,
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  KmsKeyId,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeGeofenceCollectionResponse(
    collectionName: ResourceName,
    collectionArn: Arn,
    description: ResourceDescription,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    createTime: Timestamp,
    updateTime: Timestamp,
    geofenceCount: Optional[
      DescribeGeofenceCollectionResponseGeofenceCountInteger
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse = {
    import DescribeGeofenceCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .collectionArn(Arn.unwrap(collectionArn): java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .optionallyWith(
        geofenceCount.map(value =>
          DescribeGeofenceCollectionResponseGeofenceCountInteger.unwrap(
            value
          ): Integer
        )
      )(_.geofenceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly =
    zio.aws.location.model.DescribeGeofenceCollectionResponse
      .wrap(buildAwsValue())
}
object DescribeGeofenceCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeGeofenceCollectionResponse =
      zio.aws.location.model.DescribeGeofenceCollectionResponse(
        collectionName,
        collectionArn,
        description,
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        kmsKeyId.map(value => value),
        tags.map(value => value),
        createTime,
        updateTime,
        geofenceCount.map(value => value)
      )
    def collectionName: ResourceName
    def collectionArn: Arn
    def description: ResourceDescription
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Optional[String]
    def kmsKeyId: Optional[KmsKeyId]
    def tags: Optional[Map[TagKey, TagValue]]
    def createTime: Timestamp
    def updateTime: Timestamp
    def geofenceCount
        : Optional[DescribeGeofenceCollectionResponseGeofenceCountInteger]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getCollectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(collectionArn)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
    def getGeofenceCount: ZIO[
      Any,
      AwsError,
      DescribeGeofenceCollectionResponseGeofenceCountInteger
    ] = AwsError.unwrapOptionField("geofenceCount", geofenceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
  ) extends zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val collectionArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.collectionArn())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
    override val geofenceCount
        : Optional[DescribeGeofenceCollectionResponseGeofenceCountInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geofenceCount())
        .map(value =>
          zio.aws.location.model.primitives
            .DescribeGeofenceCollectionResponseGeofenceCountInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionResponse
  ): zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
