package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DescribeKeyRequest(keyName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeKeyRequest = {
    import DescribeKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeKeyRequest
      .builder()
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeKeyRequest.ReadOnly =
    zio.aws.location.model.DescribeKeyRequest.wrap(buildAwsValue())
}
object DescribeKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeKeyRequest =
      zio.aws.location.model.DescribeKeyRequest(keyName)
    def keyName: ResourceName
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeKeyRequest
  ) extends zio.aws.location.model.DescribeKeyRequest.ReadOnly {
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeKeyRequest
  ): zio.aws.location.model.DescribeKeyRequest.ReadOnly = new Wrapper(impl)
}
