package zio.aws.location.model
import zio.aws.location.model.primitives.{
  GeoArn,
  ResourceDescription,
  Timestamp,
  TagValue,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeMapResponse(
    mapName: ResourceName,
    mapArn: GeoArn,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    dataSource: String,
    configuration: zio.aws.location.model.MapConfiguration,
    description: ResourceDescription,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    createTime: Timestamp,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeMapResponse = {
    import DescribeMapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeMapResponse
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .mapArn(GeoArn.unwrap(mapArn): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .dataSource(dataSource: java.lang.String)
      .configuration(configuration.buildAwsValue())
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeMapResponse.ReadOnly =
    zio.aws.location.model.DescribeMapResponse.wrap(buildAwsValue())
}
object DescribeMapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeMapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeMapResponse =
      zio.aws.location.model.DescribeMapResponse(
        mapName,
        mapArn,
        pricingPlan.map(value => value),
        dataSource,
        configuration.asEditable,
        description,
        tags.map(value => value),
        createTime,
        updateTime
      )
    def mapName: ResourceName
    def mapArn: GeoArn
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def dataSource: String
    def configuration: zio.aws.location.model.MapConfiguration.ReadOnly
    def description: ResourceDescription
    def tags: Optional[Map[TagKey, TagValue]]
    def createTime: Timestamp
    def updateTime: Timestamp
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getMapArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(mapArn)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.location.model.MapConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeMapResponse
  ) extends zio.aws.location.model.DescribeMapResponse.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val mapArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.mapArn())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val dataSource: String = impl.dataSource(): String
    override val configuration
        : zio.aws.location.model.MapConfiguration.ReadOnly =
      zio.aws.location.model.MapConfiguration.wrap(impl.configuration())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeMapResponse
  ): zio.aws.location.model.DescribeMapResponse.ReadOnly = new Wrapper(impl)
}
