package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DescribePlaceIndexRequest(indexName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest = {
    import DescribePlaceIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribePlaceIndexRequest.ReadOnly =
    zio.aws.location.model.DescribePlaceIndexRequest.wrap(buildAwsValue())
}
object DescribePlaceIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribePlaceIndexRequest =
      zio.aws.location.model.DescribePlaceIndexRequest(indexName)
    def indexName: ResourceName
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest
  ) extends zio.aws.location.model.DescribePlaceIndexRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribePlaceIndexRequest
  ): zio.aws.location.model.DescribePlaceIndexRequest.ReadOnly = new Wrapper(
    impl
  )
}
