package zio.aws.location.model
import zio.aws.location.model.primitives.{
  GeoArn,
  ResourceDescription,
  Timestamp,
  TagValue,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeRouteCalculatorResponse(
    calculatorName: ResourceName,
    calculatorArn: GeoArn,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    description: ResourceDescription,
    createTime: Timestamp,
    updateTime: Timestamp,
    dataSource: String,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse = {
    import DescribeRouteCalculatorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .calculatorArn(GeoArn.unwrap(calculatorArn): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly =
    zio.aws.location.model.DescribeRouteCalculatorResponse.wrap(buildAwsValue())
}
object DescribeRouteCalculatorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeRouteCalculatorResponse =
      zio.aws.location.model.DescribeRouteCalculatorResponse(
        calculatorName,
        calculatorArn,
        pricingPlan.map(value => value),
        description,
        createTime,
        updateTime,
        dataSource,
        tags.map(value => value)
      )
    def calculatorName: ResourceName
    def calculatorArn: GeoArn
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def description: ResourceDescription
    def createTime: Timestamp
    def updateTime: Timestamp
    def dataSource: String
    def tags: Optional[Map[TagKey, TagValue]]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getCalculatorArn: ZIO[Any, Nothing, GeoArn] = ZIO.succeed(calculatorArn)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
  ) extends zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val calculatorArn: GeoArn =
      zio.aws.location.model.primitives.GeoArn(impl.calculatorArn())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
    override val dataSource: String = impl.dataSource(): String
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeRouteCalculatorResponse
  ): zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly =
    new Wrapper(impl)
}
