package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DescribeTrackerRequest(trackerName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeTrackerRequest = {
    import DescribeTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeTrackerRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeTrackerRequest.ReadOnly =
    zio.aws.location.model.DescribeTrackerRequest.wrap(buildAwsValue())
}
object DescribeTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeTrackerRequest =
      zio.aws.location.model.DescribeTrackerRequest(trackerName)
    def trackerName: ResourceName
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeTrackerRequest
  ) extends zio.aws.location.model.DescribeTrackerRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeTrackerRequest
  ): zio.aws.location.model.DescribeTrackerRequest.ReadOnly = new Wrapper(impl)
}
