package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  KmsKeyId,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeTrackerResponse(
    trackerName: ResourceName,
    trackerArn: Arn,
    description: ResourceDescription,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    createTime: Timestamp,
    updateTime: Timestamp,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    positionFiltering: Optional[zio.aws.location.model.PositionFiltering] =
      Optional.Absent,
    eventBridgeEnabled: Optional[Boolean] = Optional.Absent,
    kmsKeyEnableGeospatialQueries: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeTrackerResponse = {
    import DescribeTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeTrackerResponse
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .trackerArn(Arn.unwrap(trackerArn): java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(positionFiltering.map(value => value.unwrap))(
        _.positionFiltering
      )
      .optionallyWith(
        eventBridgeEnabled.map(value => value: java.lang.Boolean)
      )(_.eventBridgeEnabled)
      .optionallyWith(
        kmsKeyEnableGeospatialQueries.map(value => value: java.lang.Boolean)
      )(_.kmsKeyEnableGeospatialQueries)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeTrackerResponse.ReadOnly =
    zio.aws.location.model.DescribeTrackerResponse.wrap(buildAwsValue())
}
object DescribeTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeTrackerResponse =
      zio.aws.location.model.DescribeTrackerResponse(
        trackerName,
        trackerArn,
        description,
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        tags.map(value => value),
        createTime,
        updateTime,
        kmsKeyId.map(value => value),
        positionFiltering.map(value => value),
        eventBridgeEnabled.map(value => value),
        kmsKeyEnableGeospatialQueries.map(value => value)
      )
    def trackerName: ResourceName
    def trackerArn: Arn
    def description: ResourceDescription
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Optional[String]
    def tags: Optional[Map[TagKey, TagValue]]
    def createTime: Timestamp
    def updateTime: Timestamp
    def kmsKeyId: Optional[KmsKeyId]
    def positionFiltering: Optional[zio.aws.location.model.PositionFiltering]
    def eventBridgeEnabled: Optional[Boolean]
    def kmsKeyEnableGeospatialQueries: Optional[Boolean]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getTrackerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(trackerArn)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPositionFiltering
        : ZIO[Any, AwsError, zio.aws.location.model.PositionFiltering] =
      AwsError.unwrapOptionField("positionFiltering", positionFiltering)
    def getEventBridgeEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("eventBridgeEnabled", eventBridgeEnabled)
    def getKmsKeyEnableGeospatialQueries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "kmsKeyEnableGeospatialQueries",
        kmsKeyEnableGeospatialQueries
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeTrackerResponse
  ) extends zio.aws.location.model.DescribeTrackerResponse.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val trackerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.trackerArn())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.location.model.primitives.KmsKeyId(value))
    override val positionFiltering
        : Optional[zio.aws.location.model.PositionFiltering] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionFiltering())
        .map(value => zio.aws.location.model.PositionFiltering.wrap(value))
    override val eventBridgeEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.eventBridgeEnabled())
      .map(value => value: Boolean)
    override val kmsKeyEnableGeospatialQueries: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyEnableGeospatialQueries())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeTrackerResponse
  ): zio.aws.location.model.DescribeTrackerResponse.ReadOnly = new Wrapper(impl)
}
