package zio.aws.location.model
import zio.aws.location.model.primitives.{
  PropertyMapValueString,
  PropertyMapKeyString,
  Timestamp,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DevicePositionUpdate(
    deviceId: Id,
    sampleTime: Timestamp,
    position: Iterable[Double],
    accuracy: Optional[zio.aws.location.model.PositionalAccuracy] =
      Optional.Absent,
    positionProperties: Optional[
      Map[PropertyMapKeyString, PropertyMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DevicePositionUpdate = {
    import DevicePositionUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DevicePositionUpdate
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .optionallyWith(
        positionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (PropertyMapKeyString
                .unwrap(key): java.lang.String) -> (PropertyMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.positionProperties)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DevicePositionUpdate.ReadOnly =
    zio.aws.location.model.DevicePositionUpdate.wrap(buildAwsValue())
}
object DevicePositionUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DevicePositionUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DevicePositionUpdate =
      zio.aws.location.model.DevicePositionUpdate(
        deviceId,
        sampleTime,
        position,
        accuracy.map(value => value.asEditable),
        positionProperties.map(value => value)
      )
    def deviceId: Id
    def sampleTime: Timestamp
    def position: List[Double]
    def accuracy: Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly]
    def positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]]
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getAccuracy: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.PositionalAccuracy.ReadOnly
    ] = AwsError.unwrapOptionField("accuracy", accuracy)
    def getPositionProperties: ZIO[Any, AwsError, Map[
      PropertyMapKeyString,
      PropertyMapValueString
    ]] = AwsError.unwrapOptionField("positionProperties", positionProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DevicePositionUpdate
  ) extends zio.aws.location.model.DevicePositionUpdate.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val accuracy
        : Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.location.model.PositionalAccuracy.wrap(value))
    override val positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.location.model.primitives
                .PropertyMapKeyString(key) -> zio.aws.location.model.primitives
                .PropertyMapValueString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DevicePositionUpdate
  ): zio.aws.location.model.DevicePositionUpdate.ReadOnly = new Wrapper(impl)
}
