package zio.aws.location.model
import zio.aws.location.model.primitives.{
  DeviceStateIpv4AddressString,
  Timestamp,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeviceState(
    deviceId: Id,
    sampleTime: Timestamp,
    position: Iterable[Double],
    accuracy: Optional[zio.aws.location.model.PositionalAccuracy] =
      Optional.Absent,
    ipv4Address: Optional[DeviceStateIpv4AddressString] = Optional.Absent,
    wiFiAccessPoints: Optional[
      Iterable[zio.aws.location.model.WiFiAccessPoint]
    ] = Optional.Absent,
    cellSignals: Optional[zio.aws.location.model.CellSignals] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeviceState = {
    import DeviceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeviceState
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .optionallyWith(
        ipv4Address.map(value =>
          DeviceStateIpv4AddressString.unwrap(value): java.lang.String
        )
      )(_.ipv4Address)
      .optionallyWith(
        wiFiAccessPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wiFiAccessPoints)
      .optionallyWith(cellSignals.map(value => value.buildAwsValue()))(
        _.cellSignals
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeviceState.ReadOnly =
    zio.aws.location.model.DeviceState.wrap(buildAwsValue())
}
object DeviceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeviceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeviceState =
      zio.aws.location.model.DeviceState(
        deviceId,
        sampleTime,
        position,
        accuracy.map(value => value.asEditable),
        ipv4Address.map(value => value),
        wiFiAccessPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cellSignals.map(value => value.asEditable)
      )
    def deviceId: Id
    def sampleTime: Timestamp
    def position: List[Double]
    def accuracy: Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly]
    def ipv4Address: Optional[DeviceStateIpv4AddressString]
    def wiFiAccessPoints
        : Optional[List[zio.aws.location.model.WiFiAccessPoint.ReadOnly]]
    def cellSignals: Optional[zio.aws.location.model.CellSignals.ReadOnly]
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getAccuracy: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.PositionalAccuracy.ReadOnly
    ] = AwsError.unwrapOptionField("accuracy", accuracy)
    def getIpv4Address: ZIO[Any, AwsError, DeviceStateIpv4AddressString] =
      AwsError.unwrapOptionField("ipv4Address", ipv4Address)
    def getWiFiAccessPoints: ZIO[Any, AwsError, List[
      zio.aws.location.model.WiFiAccessPoint.ReadOnly
    ]] = AwsError.unwrapOptionField("wiFiAccessPoints", wiFiAccessPoints)
    def getCellSignals
        : ZIO[Any, AwsError, zio.aws.location.model.CellSignals.ReadOnly] =
      AwsError.unwrapOptionField("cellSignals", cellSignals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeviceState
  ) extends zio.aws.location.model.DeviceState.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val accuracy
        : Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.location.model.PositionalAccuracy.wrap(value))
    override val ipv4Address: Optional[DeviceStateIpv4AddressString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipv4Address())
        .map(value =>
          zio.aws.location.model.primitives.DeviceStateIpv4AddressString(value)
        )
    override val wiFiAccessPoints
        : Optional[List[zio.aws.location.model.WiFiAccessPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wiFiAccessPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.WiFiAccessPoint.wrap(item)
          }.toList
        )
    override val cellSignals
        : Optional[zio.aws.location.model.CellSignals.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cellSignals())
        .map(value => zio.aws.location.model.CellSignals.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeviceState
  ): zio.aws.location.model.DeviceState.ReadOnly = new Wrapper(impl)
}
