package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait DistanceUnit {
  def unwrap: software.amazon.awssdk.services.location.model.DistanceUnit
}
object DistanceUnit {
  def wrap(
      value: software.amazon.awssdk.services.location.model.DistanceUnit
  ): zio.aws.location.model.DistanceUnit = value match {
    case software.amazon.awssdk.services.location.model.DistanceUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.DistanceUnit.KILOMETERS =>
      val r = Kilometers
      r
    case software.amazon.awssdk.services.location.model.DistanceUnit.MILES =>
      val r = Miles
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.DistanceUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.DistanceUnit =
      software.amazon.awssdk.services.location.model.DistanceUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Kilometers extends zio.aws.location.model.DistanceUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.DistanceUnit =
      software.amazon.awssdk.services.location.model.DistanceUnit.KILOMETERS
  }
  case object Miles extends zio.aws.location.model.DistanceUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.DistanceUnit =
      software.amazon.awssdk.services.location.model.DistanceUnit.MILES
  }
}
