package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.ForecastGeofenceEventsDeviceStateSpeedDouble
import scala.jdk.CollectionConverters._
final case class ForecastGeofenceEventsDeviceState(
    position: Iterable[Double],
    speed: Optional[ForecastGeofenceEventsDeviceStateSpeedDouble] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ForecastGeofenceEventsDeviceState = {
    import ForecastGeofenceEventsDeviceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ForecastGeofenceEventsDeviceState
      .builder()
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        speed.map(value =>
          ForecastGeofenceEventsDeviceStateSpeedDouble.unwrap(
            value
          ): java.lang.Double
        )
      )(_.speed)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ForecastGeofenceEventsDeviceState.ReadOnly =
    zio.aws.location.model.ForecastGeofenceEventsDeviceState
      .wrap(buildAwsValue())
}
object ForecastGeofenceEventsDeviceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ForecastGeofenceEventsDeviceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ForecastGeofenceEventsDeviceState =
      zio.aws.location.model
        .ForecastGeofenceEventsDeviceState(position, speed.map(value => value))
    def position: List[Double]
    def speed: Optional[ForecastGeofenceEventsDeviceStateSpeedDouble]
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getSpeed
        : ZIO[Any, AwsError, ForecastGeofenceEventsDeviceStateSpeedDouble] =
      AwsError.unwrapOptionField("speed", speed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ForecastGeofenceEventsDeviceState
  ) extends zio.aws.location.model.ForecastGeofenceEventsDeviceState.ReadOnly {
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val speed: Optional[ForecastGeofenceEventsDeviceStateSpeedDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speed())
        .map(value =>
          zio.aws.location.model.primitives
            .ForecastGeofenceEventsDeviceStateSpeedDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ForecastGeofenceEventsDeviceState
  ): zio.aws.location.model.ForecastGeofenceEventsDeviceState.ReadOnly =
    new Wrapper(impl)
}
