package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ForecastGeofenceEventsRequestMaxResultsInteger,
  LargeToken,
  ForecastGeofenceEventsRequestTimeHorizonMinutesDouble,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ForecastGeofenceEventsRequest(
    collectionName: ResourceName,
    deviceState: zio.aws.location.model.ForecastGeofenceEventsDeviceState,
    timeHorizonMinutes: Optional[
      ForecastGeofenceEventsRequestTimeHorizonMinutesDouble
    ] = Optional.Absent,
    distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      Optional.Absent,
    speedUnit: Optional[zio.aws.location.model.SpeedUnit] = Optional.Absent,
    nextToken: Optional[LargeToken] = Optional.Absent,
    maxResults: Optional[ForecastGeofenceEventsRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest = {
    import ForecastGeofenceEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .deviceState(deviceState.buildAwsValue())
      .optionallyWith(
        timeHorizonMinutes.map(value =>
          ForecastGeofenceEventsRequestTimeHorizonMinutesDouble.unwrap(
            value
          ): java.lang.Double
        )
      )(_.timeHorizonMinutes)
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(speedUnit.map(value => value.unwrap))(_.speedUnit)
      .optionallyWith(
        nextToken.map(value => LargeToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ForecastGeofenceEventsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ForecastGeofenceEventsRequest.ReadOnly =
    zio.aws.location.model.ForecastGeofenceEventsRequest.wrap(buildAwsValue())
}
object ForecastGeofenceEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ForecastGeofenceEventsRequest =
      zio.aws.location.model.ForecastGeofenceEventsRequest(
        collectionName,
        deviceState.asEditable,
        timeHorizonMinutes.map(value => value),
        distanceUnit.map(value => value),
        speedUnit.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def collectionName: ResourceName
    def deviceState
        : zio.aws.location.model.ForecastGeofenceEventsDeviceState.ReadOnly
    def timeHorizonMinutes
        : Optional[ForecastGeofenceEventsRequestTimeHorizonMinutesDouble]
    def distanceUnit: Optional[zio.aws.location.model.DistanceUnit]
    def speedUnit: Optional[zio.aws.location.model.SpeedUnit]
    def nextToken: Optional[LargeToken]
    def maxResults: Optional[ForecastGeofenceEventsRequestMaxResultsInteger]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getDeviceState: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.ForecastGeofenceEventsDeviceState.ReadOnly
    ] = ZIO.succeed(deviceState)
    def getTimeHorizonMinutes: ZIO[
      Any,
      AwsError,
      ForecastGeofenceEventsRequestTimeHorizonMinutesDouble
    ] = AwsError.unwrapOptionField("timeHorizonMinutes", timeHorizonMinutes)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.location.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getSpeedUnit: ZIO[Any, AwsError, zio.aws.location.model.SpeedUnit] =
      AwsError.unwrapOptionField("speedUnit", speedUnit)
    def getNextToken: ZIO[Any, AwsError, LargeToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ForecastGeofenceEventsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest
  ) extends zio.aws.location.model.ForecastGeofenceEventsRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val deviceState
        : zio.aws.location.model.ForecastGeofenceEventsDeviceState.ReadOnly =
      zio.aws.location.model.ForecastGeofenceEventsDeviceState
        .wrap(impl.deviceState())
    override val timeHorizonMinutes
        : Optional[ForecastGeofenceEventsRequestTimeHorizonMinutesDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeHorizonMinutes())
        .map(value =>
          zio.aws.location.model.primitives
            .ForecastGeofenceEventsRequestTimeHorizonMinutesDouble(value)
        )
    override val distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.location.model.DistanceUnit.wrap(value))
    override val speedUnit: Optional[zio.aws.location.model.SpeedUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.speedUnit())
        .map(value => zio.aws.location.model.SpeedUnit.wrap(value))
    override val nextToken: Optional[LargeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.LargeToken(value))
    override val maxResults
        : Optional[ForecastGeofenceEventsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ForecastGeofenceEventsRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ForecastGeofenceEventsRequest
  ): zio.aws.location.model.ForecastGeofenceEventsRequest.ReadOnly =
    new Wrapper(impl)
}
