package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.LargeToken
import scala.jdk.CollectionConverters._
final case class ForecastGeofenceEventsResponse(
    forecastedEvents: Iterable[zio.aws.location.model.ForecastedEvent],
    nextToken: Optional[LargeToken] = Optional.Absent,
    distanceUnit: zio.aws.location.model.DistanceUnit,
    speedUnit: zio.aws.location.model.SpeedUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse = {
    import ForecastGeofenceEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse
      .builder()
      .forecastedEvents(forecastedEvents.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => LargeToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .distanceUnit(distanceUnit.unwrap)
      .speedUnit(speedUnit.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ForecastGeofenceEventsResponse.ReadOnly =
    zio.aws.location.model.ForecastGeofenceEventsResponse.wrap(buildAwsValue())
}
object ForecastGeofenceEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ForecastGeofenceEventsResponse =
      zio.aws.location.model.ForecastGeofenceEventsResponse(
        forecastedEvents.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        distanceUnit,
        speedUnit
      )
    def forecastedEvents: List[zio.aws.location.model.ForecastedEvent.ReadOnly]
    def nextToken: Optional[LargeToken]
    def distanceUnit: zio.aws.location.model.DistanceUnit
    def speedUnit: zio.aws.location.model.SpeedUnit
    def getForecastedEvents: ZIO[Any, Nothing, List[
      zio.aws.location.model.ForecastedEvent.ReadOnly
    ]] = ZIO.succeed(forecastedEvents)
    def getNextToken: ZIO[Any, AwsError, LargeToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.location.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
    def getSpeedUnit: ZIO[Any, Nothing, zio.aws.location.model.SpeedUnit] =
      ZIO.succeed(speedUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse
  ) extends zio.aws.location.model.ForecastGeofenceEventsResponse.ReadOnly {
    override val forecastedEvents
        : List[zio.aws.location.model.ForecastedEvent.ReadOnly] = impl
      .forecastedEvents()
      .asScala
      .map { item =>
        zio.aws.location.model.ForecastedEvent.wrap(item)
      }
      .toList
    override val nextToken: Optional[LargeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.LargeToken(value))
    override val distanceUnit: zio.aws.location.model.DistanceUnit =
      zio.aws.location.model.DistanceUnit.wrap(impl.distanceUnit())
    override val speedUnit: zio.aws.location.model.SpeedUnit =
      zio.aws.location.model.SpeedUnit.wrap(impl.speedUnit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ForecastGeofenceEventsResponse
  ): zio.aws.location.model.ForecastGeofenceEventsResponse.ReadOnly =
    new Wrapper(impl)
}
