package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait ForecastedGeofenceEventType {
  def unwrap: software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType
}
object ForecastedGeofenceEventType {
  def wrap(
      value: software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType
  ): zio.aws.location.model.ForecastedGeofenceEventType = value match {
    case software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.ENTER =>
      val r = ENTER
      r
    case software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.EXIT =>
      val r = EXIT
      r
    case software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.IDLE =>
      val r = IDLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.location.model.ForecastedGeofenceEventType {
    override def unwrap
        : software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType =
      software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENTER extends zio.aws.location.model.ForecastedGeofenceEventType {
    override def unwrap
        : software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType =
      software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.ENTER
  }
  case object EXIT extends zio.aws.location.model.ForecastedGeofenceEventType {
    override def unwrap
        : software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType =
      software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.EXIT
  }
  case object IDLE extends zio.aws.location.model.ForecastedGeofenceEventType {
    override def unwrap
        : software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType =
      software.amazon.awssdk.services.location.model.ForecastedGeofenceEventType.IDLE
  }
}
