package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.Base64EncodedGeobuf
import scala.jdk.CollectionConverters._
final case class GeofenceGeometry(
    polygon: Optional[Iterable[Iterable[Iterable[Double]]]] = Optional.Absent,
    circle: Optional[zio.aws.location.model.Circle] = Optional.Absent,
    geobuf: Optional[Base64EncodedGeobuf] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GeofenceGeometry = {
    import GeofenceGeometry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GeofenceGeometry
      .builder()
      .optionallyWith(
        polygon.map(value =>
          value.map { item =>
            item.map { item =>
              item.map { item =>
                item: java.lang.Double
              }.asJavaCollection
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.polygon)
      .optionallyWith(circle.map(value => value.buildAwsValue()))(_.circle)
      .optionallyWith(
        geobuf.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.geobuf)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GeofenceGeometry.ReadOnly =
    zio.aws.location.model.GeofenceGeometry.wrap(buildAwsValue())
}
object GeofenceGeometry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GeofenceGeometry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GeofenceGeometry =
      zio.aws.location.model.GeofenceGeometry(
        polygon.map(value => value),
        circle.map(value => value.asEditable),
        geobuf.map(value => value)
      )
    def polygon: Optional[List[List[List[Double]]]]
    def circle: Optional[zio.aws.location.model.Circle.ReadOnly]
    def geobuf: Optional[Base64EncodedGeobuf]
    def getPolygon: ZIO[Any, AwsError, List[List[List[Double]]]] =
      AwsError.unwrapOptionField("polygon", polygon)
    def getCircle: ZIO[Any, AwsError, zio.aws.location.model.Circle.ReadOnly] =
      AwsError.unwrapOptionField("circle", circle)
    def getGeobuf: ZIO[Any, AwsError, Base64EncodedGeobuf] =
      AwsError.unwrapOptionField("geobuf", geobuf)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GeofenceGeometry
  ) extends zio.aws.location.model.GeofenceGeometry.ReadOnly {
    override val polygon: Optional[List[List[List[Double]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.polygon())
        .map(value =>
          value.asScala.map { item =>
            item.asScala.map { item =>
              item.asScala.map { item =>
                item: Double
              }.toList
            }.toList
          }.toList
        )
    override val circle: Optional[zio.aws.location.model.Circle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.circle())
        .map(value => zio.aws.location.model.Circle.wrap(value))
    override val geobuf: Optional[Base64EncodedGeobuf] = zio.aws.core.internal
      .optionalFromNullable(impl.geobuf())
      .map(value =>
        zio.aws.location.model.primitives
          .Base64EncodedGeobuf(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GeofenceGeometry
  ): zio.aws.location.model.GeofenceGeometry.ReadOnly = new Wrapper(impl)
}
