package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  Timestamp,
  GetDevicePositionHistoryRequestMaxResultsInteger,
  ResourceName,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDevicePositionHistoryRequest(
    trackerName: ResourceName,
    deviceId: Id,
    nextToken: Optional[Token] = Optional.Absent,
    startTimeInclusive: Optional[Timestamp] = Optional.Absent,
    endTimeExclusive: Optional[Timestamp] = Optional.Absent,
    maxResults: Optional[GetDevicePositionHistoryRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest = {
    import GetDevicePositionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        startTimeInclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.startTimeInclusive)
      .optionallyWith(
        endTimeExclusive.map(value => Timestamp.unwrap(value): Instant)
      )(_.endTimeExclusive)
      .optionallyWith(
        maxResults.map(value =>
          GetDevicePositionHistoryRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.GetDevicePositionHistoryRequest.ReadOnly =
    zio.aws.location.model.GetDevicePositionHistoryRequest.wrap(buildAwsValue())
}
object GetDevicePositionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetDevicePositionHistoryRequest =
      zio.aws.location.model.GetDevicePositionHistoryRequest(
        trackerName,
        deviceId,
        nextToken.map(value => value),
        startTimeInclusive.map(value => value),
        endTimeExclusive.map(value => value),
        maxResults.map(value => value)
      )
    def trackerName: ResourceName
    def deviceId: Id
    def nextToken: Optional[Token]
    def startTimeInclusive: Optional[Timestamp]
    def endTimeExclusive: Optional[Timestamp]
    def maxResults: Optional[GetDevicePositionHistoryRequestMaxResultsInteger]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTimeInclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTimeInclusive", startTimeInclusive)
    def getEndTimeExclusive: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTimeExclusive", endTimeExclusive)
    def getMaxResults
        : ZIO[Any, AwsError, GetDevicePositionHistoryRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
  ) extends zio.aws.location.model.GetDevicePositionHistoryRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
    override val startTimeInclusive: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimeInclusive())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val endTimeExclusive: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTimeExclusive())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val maxResults
        : Optional[GetDevicePositionHistoryRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .GetDevicePositionHistoryRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest
  ): zio.aws.location.model.GetDevicePositionHistoryRequest.ReadOnly =
    new Wrapper(impl)
}
