package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{Id, ResourceName}
import scala.jdk.CollectionConverters._
final case class GetDevicePositionRequest(
    trackerName: ResourceName,
    deviceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetDevicePositionRequest = {
    import GetDevicePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetDevicePositionRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetDevicePositionRequest.ReadOnly =
    zio.aws.location.model.GetDevicePositionRequest.wrap(buildAwsValue())
}
object GetDevicePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetDevicePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetDevicePositionRequest =
      zio.aws.location.model.GetDevicePositionRequest(trackerName, deviceId)
    def trackerName: ResourceName
    def deviceId: Id
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionRequest
  ) extends zio.aws.location.model.GetDevicePositionRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionRequest
  ): zio.aws.location.model.GetDevicePositionRequest.ReadOnly = new Wrapper(
    impl
  )
}
