package zio.aws.location.model
import zio.aws.location.model.primitives.{
  PropertyMapValueString,
  PropertyMapKeyString,
  Timestamp,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDevicePositionResponse(
    deviceId: Optional[Id] = Optional.Absent,
    sampleTime: Timestamp,
    receivedTime: Timestamp,
    position: Iterable[Double],
    accuracy: Optional[zio.aws.location.model.PositionalAccuracy] =
      Optional.Absent,
    positionProperties: Optional[
      Map[PropertyMapKeyString, PropertyMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetDevicePositionResponse = {
    import GetDevicePositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetDevicePositionResponse
      .builder()
      .optionallyWith(
        deviceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deviceId)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .receivedTime(Timestamp.unwrap(receivedTime): Instant)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .optionallyWith(
        positionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (PropertyMapKeyString
                .unwrap(key): java.lang.String) -> (PropertyMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.positionProperties)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetDevicePositionResponse.ReadOnly =
    zio.aws.location.model.GetDevicePositionResponse.wrap(buildAwsValue())
}
object GetDevicePositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetDevicePositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetDevicePositionResponse =
      zio.aws.location.model.GetDevicePositionResponse(
        deviceId.map(value => value),
        sampleTime,
        receivedTime,
        position,
        accuracy.map(value => value.asEditable),
        positionProperties.map(value => value)
      )
    def deviceId: Optional[Id]
    def sampleTime: Timestamp
    def receivedTime: Timestamp
    def position: List[Double]
    def accuracy: Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly]
    def positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]]
    def getDeviceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
    def getReceivedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(receivedTime)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getAccuracy: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.PositionalAccuracy.ReadOnly
    ] = AwsError.unwrapOptionField("accuracy", accuracy)
    def getPositionProperties: ZIO[Any, AwsError, Map[
      PropertyMapKeyString,
      PropertyMapValueString
    ]] = AwsError.unwrapOptionField("positionProperties", positionProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionResponse
  ) extends zio.aws.location.model.GetDevicePositionResponse.ReadOnly {
    override val deviceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.location.model.primitives.Id(value))
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
    override val receivedTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.receivedTime())
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val accuracy
        : Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.location.model.PositionalAccuracy.wrap(value))
    override val positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.location.model.primitives
                .PropertyMapKeyString(key) -> zio.aws.location.model.primitives
                .PropertyMapValueString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionResponse
  ): zio.aws.location.model.GetDevicePositionResponse.ReadOnly = new Wrapper(
    impl
  )
}
