package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ApiKey,
  GetMapGlyphsRequestFontUnicodeRangeString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetMapGlyphsRequest(
    mapName: ResourceName,
    fontStack: String,
    fontUnicodeRange: GetMapGlyphsRequestFontUnicodeRangeString,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapGlyphsRequest = {
    import GetMapGlyphsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .fontStack(fontStack: java.lang.String)
      .fontUnicodeRange(
        GetMapGlyphsRequestFontUnicodeRangeString.unwrap(
          fontUnicodeRange
        ): java.lang.String
      )
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapGlyphsRequest.ReadOnly =
    zio.aws.location.model.GetMapGlyphsRequest.wrap(buildAwsValue())
}
object GetMapGlyphsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapGlyphsRequest =
      zio.aws.location.model.GetMapGlyphsRequest(
        mapName,
        fontStack,
        fontUnicodeRange,
        key.map(value => value)
      )
    def mapName: ResourceName
    def fontStack: String
    def fontUnicodeRange: GetMapGlyphsRequestFontUnicodeRangeString
    def key: Optional[ApiKey]
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getFontStack: ZIO[Any, Nothing, String] = ZIO.succeed(fontStack)
    def getFontUnicodeRange
        : ZIO[Any, Nothing, GetMapGlyphsRequestFontUnicodeRangeString] =
      ZIO.succeed(fontUnicodeRange)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
  ) extends zio.aws.location.model.GetMapGlyphsRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val fontStack: String = impl.fontStack(): String
    override val fontUnicodeRange: GetMapGlyphsRequestFontUnicodeRangeString =
      zio.aws.location.model.primitives
        .GetMapGlyphsRequestFontUnicodeRangeString(impl.fontUnicodeRange())
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapGlyphsRequest
  ): zio.aws.location.model.GetMapGlyphsRequest.ReadOnly = new Wrapper(impl)
}
