package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ApiKey,
  GetMapSpritesRequestFileNameString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetMapSpritesRequest(
    mapName: ResourceName,
    fileName: GetMapSpritesRequestFileNameString,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapSpritesRequest = {
    import GetMapSpritesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapSpritesRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .fileName(
        GetMapSpritesRequestFileNameString.unwrap(fileName): java.lang.String
      )
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapSpritesRequest.ReadOnly =
    zio.aws.location.model.GetMapSpritesRequest.wrap(buildAwsValue())
}
object GetMapSpritesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapSpritesRequest =
      zio.aws.location.model
        .GetMapSpritesRequest(mapName, fileName, key.map(value => value))
    def mapName: ResourceName
    def fileName: GetMapSpritesRequestFileNameString
    def key: Optional[ApiKey]
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getFileName: ZIO[Any, Nothing, GetMapSpritesRequestFileNameString] =
      ZIO.succeed(fileName)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ) extends zio.aws.location.model.GetMapSpritesRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val fileName: GetMapSpritesRequestFileNameString =
      zio.aws.location.model.primitives
        .GetMapSpritesRequestFileNameString(impl.fileName())
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ): zio.aws.location.model.GetMapSpritesRequest.ReadOnly = new Wrapper(impl)
}
