package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{ApiKey, ResourceName}
import scala.jdk.CollectionConverters._
final case class GetMapStyleDescriptorRequest(
    mapName: ResourceName,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest = {
    import GetMapStyleDescriptorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly =
    zio.aws.location.model.GetMapStyleDescriptorRequest.wrap(buildAwsValue())
}
object GetMapStyleDescriptorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapStyleDescriptorRequest =
      zio.aws.location.model
        .GetMapStyleDescriptorRequest(mapName, key.map(value => value))
    def mapName: ResourceName
    def key: Optional[ApiKey]
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ) extends zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorRequest
  ): zio.aws.location.model.GetMapStyleDescriptorRequest.ReadOnly = new Wrapper(
    impl
  )
}
