package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.Blob
import scala.jdk.CollectionConverters._
final case class GetMapStyleDescriptorResponse(
    blob: Optional[Blob] = Optional.Absent,
    contentType: Optional[String] = Optional.Absent,
    cacheControl: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse = {
    import GetMapStyleDescriptorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
      .builder()
      .optionallyWith(
        blob.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.blob)
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(cacheControl.map(value => value: java.lang.String))(
        _.cacheControl
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly =
    zio.aws.location.model.GetMapStyleDescriptorResponse.wrap(buildAwsValue())
}
object GetMapStyleDescriptorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapStyleDescriptorResponse =
      zio.aws.location.model.GetMapStyleDescriptorResponse(
        blob.map(value => value),
        contentType.map(value => value),
        cacheControl.map(value => value)
      )
    def blob: Optional[Blob]
    def contentType: Optional[String]
    def cacheControl: Optional[String]
    def getBlob: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blob", blob)
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCacheControl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cacheControl", cacheControl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
  ) extends zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly {
    override val blob: Optional[Blob] = zio.aws.core.internal
      .optionalFromNullable(impl.blob())
      .map(value =>
        zio.aws.location.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val contentType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => value: String)
    override val cacheControl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cacheControl())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapStyleDescriptorResponse
  ): zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly =
    new Wrapper(impl)
}
