package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ApiKey,
  GetMapTileRequestYString,
  GetMapTileRequestZString,
  GetMapTileRequestXString,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetMapTileRequest(
    mapName: ResourceName,
    z: GetMapTileRequestZString,
    x: GetMapTileRequestXString,
    y: GetMapTileRequestYString,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapTileRequest = {
    import GetMapTileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapTileRequest
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .z(GetMapTileRequestZString.unwrap(z): java.lang.String)
      .x(GetMapTileRequestXString.unwrap(x): java.lang.String)
      .y(GetMapTileRequestYString.unwrap(y): java.lang.String)
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapTileRequest.ReadOnly =
    zio.aws.location.model.GetMapTileRequest.wrap(buildAwsValue())
}
object GetMapTileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapTileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapTileRequest =
      zio.aws.location.model.GetMapTileRequest(
        mapName,
        z,
        x,
        y,
        key.map(value => value)
      )
    def mapName: ResourceName
    def z: GetMapTileRequestZString
    def x: GetMapTileRequestXString
    def y: GetMapTileRequestYString
    def key: Optional[ApiKey]
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getZ: ZIO[Any, Nothing, GetMapTileRequestZString] = ZIO.succeed(z)
    def getX: ZIO[Any, Nothing, GetMapTileRequestXString] = ZIO.succeed(x)
    def getY: ZIO[Any, Nothing, GetMapTileRequestYString] = ZIO.succeed(y)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapTileRequest
  ) extends zio.aws.location.model.GetMapTileRequest.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val z: GetMapTileRequestZString =
      zio.aws.location.model.primitives.GetMapTileRequestZString(impl.z())
    override val x: GetMapTileRequestXString =
      zio.aws.location.model.primitives.GetMapTileRequestXString(impl.x())
    override val y: GetMapTileRequestYString =
      zio.aws.location.model.primitives.GetMapTileRequestYString(impl.y())
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapTileRequest
  ): zio.aws.location.model.GetMapTileRequest.ReadOnly = new Wrapper(impl)
}
