package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  ApiKey,
  LanguageTag,
  PlaceId,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class GetPlaceRequest(
    indexName: ResourceName,
    placeId: PlaceId,
    language: Optional[LanguageTag] = Optional.Absent,
    key: Optional[ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetPlaceRequest = {
    import GetPlaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetPlaceRequest
      .builder()
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .placeId(PlaceId.unwrap(placeId): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(key.map(value => ApiKey.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetPlaceRequest.ReadOnly =
    zio.aws.location.model.GetPlaceRequest.wrap(buildAwsValue())
}
object GetPlaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetPlaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetPlaceRequest =
      zio.aws.location.model.GetPlaceRequest(
        indexName,
        placeId,
        language.map(value => value),
        key.map(value => value)
      )
    def indexName: ResourceName
    def placeId: PlaceId
    def language: Optional[LanguageTag]
    def key: Optional[ApiKey]
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getPlaceId: ZIO[Any, Nothing, PlaceId] = ZIO.succeed(placeId)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getKey: ZIO[Any, AwsError, ApiKey] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetPlaceRequest
  ) extends zio.aws.location.model.GetPlaceRequest.ReadOnly {
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val placeId: PlaceId =
      zio.aws.location.model.primitives.PlaceId(impl.placeId())
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val key: Optional[ApiKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.location.model.primitives.ApiKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetPlaceRequest
  ): zio.aws.location.model.GetPlaceRequest.ReadOnly = new Wrapper(impl)
}
