package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InferredState(
    position: Optional[Iterable[Double]] = Optional.Absent,
    accuracy: Optional[zio.aws.location.model.PositionalAccuracy] =
      Optional.Absent,
    deviationDistance: Optional[Double] = Optional.Absent,
    proxyDetected: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.InferredState = {
    import InferredState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.InferredState
      .builder()
      .optionallyWith(
        position.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.position)
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .optionallyWith(deviationDistance.map(value => value: java.lang.Double))(
        _.deviationDistance
      )
      .proxyDetected(proxyDetected: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.location.model.InferredState.ReadOnly =
    zio.aws.location.model.InferredState.wrap(buildAwsValue())
}
object InferredState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.InferredState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.InferredState =
      zio.aws.location.model.InferredState(
        position.map(value => value),
        accuracy.map(value => value.asEditable),
        deviationDistance.map(value => value),
        proxyDetected
      )
    def position: Optional[List[Double]]
    def accuracy: Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly]
    def deviationDistance: Optional[Double]
    def proxyDetected: Boolean
    def getPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("position", position)
    def getAccuracy: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.PositionalAccuracy.ReadOnly
    ] = AwsError.unwrapOptionField("accuracy", accuracy)
    def getDeviationDistance: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("deviationDistance", deviationDistance)
    def getProxyDetected: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(proxyDetected)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.InferredState
  ) extends zio.aws.location.model.InferredState.ReadOnly {
    override val position: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.position())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val accuracy
        : Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.location.model.PositionalAccuracy.wrap(value))
    override val deviationDistance: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.deviationDistance())
      .map(value => value: Double)
    override val proxyDetected: Boolean = impl.proxyDetected(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.InferredState
  ): zio.aws.location.model.InferredState.ReadOnly = new Wrapper(impl)
}
