package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  LegDurationSecondsDouble,
  LegDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class Leg(
    startPosition: Iterable[Double],
    endPosition: Iterable[Double],
    distance: LegDistanceDouble,
    durationSeconds: LegDurationSecondsDouble,
    geometry: Optional[zio.aws.location.model.LegGeometry] = Optional.Absent,
    steps: Iterable[zio.aws.location.model.Step]
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Leg = {
    import Leg.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Leg
      .builder()
      .startPosition(startPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .endPosition(endPosition.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .distance(LegDistanceDouble.unwrap(distance): java.lang.Double)
      .durationSeconds(
        LegDurationSecondsDouble.unwrap(durationSeconds): java.lang.Double
      )
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .steps(steps.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Leg.ReadOnly =
    zio.aws.location.model.Leg.wrap(buildAwsValue())
}
object Leg {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Leg] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Leg = zio.aws.location.model.Leg(
      startPosition,
      endPosition,
      distance,
      durationSeconds,
      geometry.map(value => value.asEditable),
      steps.map { item =>
        item.asEditable
      }
    )
    def startPosition: List[Double]
    def endPosition: List[Double]
    def distance: LegDistanceDouble
    def durationSeconds: LegDurationSecondsDouble
    def geometry: Optional[zio.aws.location.model.LegGeometry.ReadOnly]
    def steps: List[zio.aws.location.model.Step.ReadOnly]
    def getStartPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(startPosition)
    def getEndPosition: ZIO[Any, Nothing, List[Double]] =
      ZIO.succeed(endPosition)
    def getDistance: ZIO[Any, Nothing, LegDistanceDouble] =
      ZIO.succeed(distance)
    def getDurationSeconds: ZIO[Any, Nothing, LegDurationSecondsDouble] =
      ZIO.succeed(durationSeconds)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.location.model.LegGeometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getSteps
        : ZIO[Any, Nothing, List[zio.aws.location.model.Step.ReadOnly]] =
      ZIO.succeed(steps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Leg
  ) extends zio.aws.location.model.Leg.ReadOnly {
    override val startPosition: List[Double] = impl
      .startPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val endPosition: List[Double] = impl
      .endPosition()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val distance: LegDistanceDouble =
      zio.aws.location.model.primitives.LegDistanceDouble(impl.distance())
    override val durationSeconds: LegDurationSecondsDouble =
      zio.aws.location.model.primitives
        .LegDurationSecondsDouble(impl.durationSeconds())
    override val geometry
        : Optional[zio.aws.location.model.LegGeometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometry())
        .map(value => zio.aws.location.model.LegGeometry.wrap(value))
    override val steps: List[zio.aws.location.model.Step.ReadOnly] = impl
      .steps()
      .asScala
      .map { item =>
        zio.aws.location.model.Step.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Leg
  ): zio.aws.location.model.Leg.ReadOnly = new Wrapper(impl)
}
