package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListDevicePositionsRequestMaxResultsInteger,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicePositionsRequest(
    trackerName: ResourceName,
    maxResults: Optional[ListDevicePositionsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    filterGeometry: Optional[zio.aws.location.model.TrackingFilterGeometry] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListDevicePositionsRequest = {
    import ListDevicePositionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListDevicePositionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(filterGeometry.map(value => value.buildAwsValue()))(
        _.filterGeometry
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListDevicePositionsRequest.ReadOnly =
    zio.aws.location.model.ListDevicePositionsRequest.wrap(buildAwsValue())
}
object ListDevicePositionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListDevicePositionsRequest =
      zio.aws.location.model.ListDevicePositionsRequest(
        trackerName,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filterGeometry.map(value => value.asEditable)
      )
    def trackerName: ResourceName
    def maxResults: Optional[ListDevicePositionsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def filterGeometry
        : Optional[zio.aws.location.model.TrackingFilterGeometry.ReadOnly]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getMaxResults
        : ZIO[Any, AwsError, ListDevicePositionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilterGeometry: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.TrackingFilterGeometry.ReadOnly
    ] = AwsError.unwrapOptionField("filterGeometry", filterGeometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ) extends zio.aws.location.model.ListDevicePositionsRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val maxResults
        : Optional[ListDevicePositionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListDevicePositionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
    override val filterGeometry
        : Optional[zio.aws.location.model.TrackingFilterGeometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterGeometry())
        .map(value => zio.aws.location.model.TrackingFilterGeometry.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ): zio.aws.location.model.ListDevicePositionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
