package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Timestamp,
  ResourceDescription,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListGeofenceCollectionsResponseEntry(
    collectionName: ResourceName,
    description: ResourceDescription,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    createTime: Timestamp,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry = {
    import ListGeofenceCollectionsResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly =
    zio.aws.location.model.ListGeofenceCollectionsResponseEntry
      .wrap(buildAwsValue())
}
object ListGeofenceCollectionsResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.ListGeofenceCollectionsResponseEntry =
      zio.aws.location.model.ListGeofenceCollectionsResponseEntry(
        collectionName,
        description,
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        createTime,
        updateTime
      )
    def collectionName: ResourceName
    def description: ResourceDescription
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Optional[String]
    def createTime: Timestamp
    def updateTime: Timestamp
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry
  ) extends zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListGeofenceCollectionsResponseEntry
  ): zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly =
    new Wrapper(impl)
}
