package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ListGeofencesRequestMaxResultsInteger,
  LargeToken,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGeofencesRequest(
    collectionName: ResourceName,
    nextToken: Optional[LargeToken] = Optional.Absent,
    maxResults: Optional[ListGeofencesRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListGeofencesRequest = {
    import ListGeofencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListGeofencesRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => LargeToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListGeofencesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListGeofencesRequest.ReadOnly =
    zio.aws.location.model.ListGeofencesRequest.wrap(buildAwsValue())
}
object ListGeofencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListGeofencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListGeofencesRequest =
      zio.aws.location.model.ListGeofencesRequest(
        collectionName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def collectionName: ResourceName
    def nextToken: Optional[LargeToken]
    def maxResults: Optional[ListGeofencesRequestMaxResultsInteger]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getNextToken: ZIO[Any, AwsError, LargeToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListGeofencesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListGeofencesRequest
  ) extends zio.aws.location.model.ListGeofencesRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val nextToken: Optional[LargeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.LargeToken(value))
    override val maxResults: Optional[ListGeofencesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListGeofencesRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListGeofencesRequest
  ): zio.aws.location.model.ListGeofencesRequest.ReadOnly = new Wrapper(impl)
}
