package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListKeysResponseEntry(
    keyName: ResourceName,
    expireTime: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent,
    restrictions: zio.aws.location.model.ApiKeyRestrictions,
    createTime: Timestamp,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListKeysResponseEntry = {
    import ListKeysResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListKeysResponseEntry
      .builder()
      .keyName(ResourceName.unwrap(keyName): java.lang.String)
      .expireTime(Timestamp.unwrap(expireTime): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .restrictions(restrictions.buildAwsValue())
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListKeysResponseEntry.ReadOnly =
    zio.aws.location.model.ListKeysResponseEntry.wrap(buildAwsValue())
}
object ListKeysResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListKeysResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListKeysResponseEntry =
      zio.aws.location.model.ListKeysResponseEntry(
        keyName,
        expireTime,
        description.map(value => value),
        restrictions.asEditable,
        createTime,
        updateTime
      )
    def keyName: ResourceName
    def expireTime: Timestamp
    def description: Optional[ResourceDescription]
    def restrictions: zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    def createTime: Timestamp
    def updateTime: Timestamp
    def getKeyName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(keyName)
    def getExpireTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(expireTime)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRestrictions: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.ApiKeyRestrictions.ReadOnly
    ] = ZIO.succeed(restrictions)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListKeysResponseEntry
  ) extends zio.aws.location.model.ListKeysResponseEntry.ReadOnly {
    override val keyName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.keyName())
    override val expireTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.expireTime())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val restrictions
        : zio.aws.location.model.ApiKeyRestrictions.ReadOnly =
      zio.aws.location.model.ApiKeyRestrictions.wrap(impl.restrictions())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListKeysResponseEntry
  ): zio.aws.location.model.ListKeysResponseEntry.ReadOnly = new Wrapper(impl)
}
