package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListMapsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListMapsRequest(
    maxResults: Optional[ListMapsRequestMaxResultsInteger] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListMapsRequest = {
    import ListMapsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListMapsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListMapsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListMapsRequest.ReadOnly =
    zio.aws.location.model.ListMapsRequest.wrap(buildAwsValue())
}
object ListMapsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListMapsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListMapsRequest =
      zio.aws.location.model.ListMapsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListMapsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getMaxResults: ZIO[Any, AwsError, ListMapsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListMapsRequest
  ) extends zio.aws.location.model.ListMapsRequest.ReadOnly {
    override val maxResults: Optional[ListMapsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListMapsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListMapsRequest
  ): zio.aws.location.model.ListMapsRequest.ReadOnly = new Wrapper(impl)
}
