package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Timestamp,
  ResourceDescription,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListMapsResponseEntry(
    mapName: ResourceName,
    description: ResourceDescription,
    dataSource: String,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    createTime: Timestamp,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListMapsResponseEntry = {
    import ListMapsResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListMapsResponseEntry
      .builder()
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListMapsResponseEntry.ReadOnly =
    zio.aws.location.model.ListMapsResponseEntry.wrap(buildAwsValue())
}
object ListMapsResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListMapsResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListMapsResponseEntry =
      zio.aws.location.model.ListMapsResponseEntry(
        mapName,
        description,
        dataSource,
        pricingPlan.map(value => value),
        createTime,
        updateTime
      )
    def mapName: ResourceName
    def description: ResourceDescription
    def dataSource: String
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def createTime: Timestamp
    def updateTime: Timestamp
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListMapsResponseEntry
  ) extends zio.aws.location.model.ListMapsResponseEntry.ReadOnly {
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val dataSource: String = impl.dataSource(): String
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListMapsResponseEntry
  ): zio.aws.location.model.ListMapsResponseEntry.ReadOnly = new Wrapper(impl)
}
