package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListPlaceIndexesRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPlaceIndexesRequest(
    maxResults: Optional[ListPlaceIndexesRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest = {
    import ListPlaceIndexesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListPlaceIndexesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListPlaceIndexesRequest.ReadOnly =
    zio.aws.location.model.ListPlaceIndexesRequest.wrap(buildAwsValue())
}
object ListPlaceIndexesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListPlaceIndexesRequest =
      zio.aws.location.model.ListPlaceIndexesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListPlaceIndexesRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getMaxResults
        : ZIO[Any, AwsError, ListPlaceIndexesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
  ) extends zio.aws.location.model.ListPlaceIndexesRequest.ReadOnly {
    override val maxResults
        : Optional[ListPlaceIndexesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListPlaceIndexesRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListPlaceIndexesRequest
  ): zio.aws.location.model.ListPlaceIndexesRequest.ReadOnly = new Wrapper(impl)
}
