package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListRouteCalculatorsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRouteCalculatorsRequest(
    maxResults: Optional[ListRouteCalculatorsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest = {
    import ListRouteCalculatorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListRouteCalculatorsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListRouteCalculatorsRequest.ReadOnly =
    zio.aws.location.model.ListRouteCalculatorsRequest.wrap(buildAwsValue())
}
object ListRouteCalculatorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListRouteCalculatorsRequest =
      zio.aws.location.model.ListRouteCalculatorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListRouteCalculatorsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getMaxResults
        : ZIO[Any, AwsError, ListRouteCalculatorsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
  ) extends zio.aws.location.model.ListRouteCalculatorsRequest.ReadOnly {
    override val maxResults
        : Optional[ListRouteCalculatorsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListRouteCalculatorsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsRequest
  ): zio.aws.location.model.ListRouteCalculatorsRequest.ReadOnly = new Wrapper(
    impl
  )
}
