package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Token,
  ListTrackerConsumersRequestMaxResultsInteger,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrackerConsumersRequest(
    trackerName: ResourceName,
    maxResults: Optional[ListTrackerConsumersRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest = {
    import ListTrackerConsumersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          ListTrackerConsumersRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListTrackerConsumersRequest.ReadOnly =
    zio.aws.location.model.ListTrackerConsumersRequest.wrap(buildAwsValue())
}
object ListTrackerConsumersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListTrackerConsumersRequest =
      zio.aws.location.model.ListTrackerConsumersRequest(
        trackerName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def trackerName: ResourceName
    def maxResults: Optional[ListTrackerConsumersRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getMaxResults
        : ZIO[Any, AwsError, ListTrackerConsumersRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
  ) extends zio.aws.location.model.ListTrackerConsumersRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val maxResults
        : Optional[ListTrackerConsumersRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListTrackerConsumersRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
  ): zio.aws.location.model.ListTrackerConsumersRequest.ReadOnly = new Wrapper(
    impl
  )
}
