package zio.aws.location.model
import zio.aws.location.model.primitives.{
  LteCellDetailsTacInteger,
  LteCellDetailsMncInteger,
  Rsrq,
  LteCellDetailsTimingAdvanceInteger,
  LteCellDetailsMccInteger,
  EutranCellId,
  Rsrp
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LteCellDetails(
    cellId: EutranCellId,
    mcc: LteCellDetailsMccInteger,
    mnc: LteCellDetailsMncInteger,
    localId: Optional[zio.aws.location.model.LteLocalId] = Optional.Absent,
    networkMeasurements: Optional[
      Iterable[zio.aws.location.model.LteNetworkMeasurements]
    ] = Optional.Absent,
    timingAdvance: Optional[LteCellDetailsTimingAdvanceInteger] =
      Optional.Absent,
    nrCapable: Optional[Boolean] = Optional.Absent,
    rsrp: Optional[Rsrp] = Optional.Absent,
    rsrq: Optional[Rsrq] = Optional.Absent,
    tac: Optional[LteCellDetailsTacInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.LteCellDetails = {
    import LteCellDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.LteCellDetails
      .builder()
      .cellId(EutranCellId.unwrap(cellId): Integer)
      .mcc(LteCellDetailsMccInteger.unwrap(mcc): Integer)
      .mnc(LteCellDetailsMncInteger.unwrap(mnc): Integer)
      .optionallyWith(localId.map(value => value.buildAwsValue()))(_.localId)
      .optionallyWith(
        networkMeasurements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkMeasurements)
      .optionallyWith(
        timingAdvance.map(value =>
          LteCellDetailsTimingAdvanceInteger.unwrap(value): Integer
        )
      )(_.timingAdvance)
      .optionallyWith(nrCapable.map(value => value: java.lang.Boolean))(
        _.nrCapable
      )
      .optionallyWith(rsrp.map(value => Rsrp.unwrap(value): Integer))(_.rsrp)
      .optionallyWith(rsrq.map(value => Rsrq.unwrap(value): java.lang.Float))(
        _.rsrq
      )
      .optionallyWith(
        tac.map(value => LteCellDetailsTacInteger.unwrap(value): Integer)
      )(_.tac)
      .build()
  }
  def asReadOnly: zio.aws.location.model.LteCellDetails.ReadOnly =
    zio.aws.location.model.LteCellDetails.wrap(buildAwsValue())
}
object LteCellDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.LteCellDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.LteCellDetails =
      zio.aws.location.model.LteCellDetails(
        cellId,
        mcc,
        mnc,
        localId.map(value => value.asEditable),
        networkMeasurements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timingAdvance.map(value => value),
        nrCapable.map(value => value),
        rsrp.map(value => value),
        rsrq.map(value => value),
        tac.map(value => value)
      )
    def cellId: EutranCellId
    def mcc: LteCellDetailsMccInteger
    def mnc: LteCellDetailsMncInteger
    def localId: Optional[zio.aws.location.model.LteLocalId.ReadOnly]
    def networkMeasurements
        : Optional[List[zio.aws.location.model.LteNetworkMeasurements.ReadOnly]]
    def timingAdvance: Optional[LteCellDetailsTimingAdvanceInteger]
    def nrCapable: Optional[Boolean]
    def rsrp: Optional[Rsrp]
    def rsrq: Optional[Rsrq]
    def tac: Optional[LteCellDetailsTacInteger]
    def getCellId: ZIO[Any, Nothing, EutranCellId] = ZIO.succeed(cellId)
    def getMcc: ZIO[Any, Nothing, LteCellDetailsMccInteger] = ZIO.succeed(mcc)
    def getMnc: ZIO[Any, Nothing, LteCellDetailsMncInteger] = ZIO.succeed(mnc)
    def getLocalId
        : ZIO[Any, AwsError, zio.aws.location.model.LteLocalId.ReadOnly] =
      AwsError.unwrapOptionField("localId", localId)
    def getNetworkMeasurements: ZIO[Any, AwsError, List[
      zio.aws.location.model.LteNetworkMeasurements.ReadOnly
    ]] = AwsError.unwrapOptionField("networkMeasurements", networkMeasurements)
    def getTimingAdvance
        : ZIO[Any, AwsError, LteCellDetailsTimingAdvanceInteger] =
      AwsError.unwrapOptionField("timingAdvance", timingAdvance)
    def getNrCapable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("nrCapable", nrCapable)
    def getRsrp: ZIO[Any, AwsError, Rsrp] =
      AwsError.unwrapOptionField("rsrp", rsrp)
    def getRsrq: ZIO[Any, AwsError, Rsrq] =
      AwsError.unwrapOptionField("rsrq", rsrq)
    def getTac: ZIO[Any, AwsError, LteCellDetailsTacInteger] =
      AwsError.unwrapOptionField("tac", tac)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.LteCellDetails
  ) extends zio.aws.location.model.LteCellDetails.ReadOnly {
    override val cellId: EutranCellId =
      zio.aws.location.model.primitives.EutranCellId(impl.cellId())
    override val mcc: LteCellDetailsMccInteger =
      zio.aws.location.model.primitives.LteCellDetailsMccInteger(impl.mcc())
    override val mnc: LteCellDetailsMncInteger =
      zio.aws.location.model.primitives.LteCellDetailsMncInteger(impl.mnc())
    override val localId: Optional[zio.aws.location.model.LteLocalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.localId())
        .map(value => zio.aws.location.model.LteLocalId.wrap(value))
    override val networkMeasurements: Optional[
      List[zio.aws.location.model.LteNetworkMeasurements.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkMeasurements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.location.model.LteNetworkMeasurements.wrap(item)
        }.toList
      )
    override val timingAdvance: Optional[LteCellDetailsTimingAdvanceInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timingAdvance())
        .map(value =>
          zio.aws.location.model.primitives
            .LteCellDetailsTimingAdvanceInteger(value)
        )
    override val nrCapable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.nrCapable())
      .map(value => value: Boolean)
    override val rsrp: Optional[Rsrp] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrp())
      .map(value => zio.aws.location.model.primitives.Rsrp(value))
    override val rsrq: Optional[Rsrq] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrq())
      .map(value => zio.aws.location.model.primitives.Rsrq(value))
    override val tac: Optional[LteCellDetailsTacInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.tac())
      .map(value =>
        zio.aws.location.model.primitives.LteCellDetailsTacInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.LteCellDetails
  ): zio.aws.location.model.LteCellDetails.ReadOnly = new Wrapper(impl)
}
