package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{Pci, Earfcn}
import scala.jdk.CollectionConverters._
final case class LteLocalId(earfcn: Earfcn, pci: Pci) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.LteLocalId = {
    import LteLocalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.LteLocalId
      .builder()
      .earfcn(Earfcn.unwrap(earfcn): Integer)
      .pci(Pci.unwrap(pci): Integer)
      .build()
  }
  def asReadOnly: zio.aws.location.model.LteLocalId.ReadOnly =
    zio.aws.location.model.LteLocalId.wrap(buildAwsValue())
}
object LteLocalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.LteLocalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.LteLocalId =
      zio.aws.location.model.LteLocalId(earfcn, pci)
    def earfcn: Earfcn
    def pci: Pci
    def getEarfcn: ZIO[Any, Nothing, Earfcn] = ZIO.succeed(earfcn)
    def getPci: ZIO[Any, Nothing, Pci] = ZIO.succeed(pci)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.LteLocalId
  ) extends zio.aws.location.model.LteLocalId.ReadOnly {
    override val earfcn: Earfcn =
      zio.aws.location.model.primitives.Earfcn(impl.earfcn())
    override val pci: Pci = zio.aws.location.model.primitives.Pci(impl.pci())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.LteLocalId
  ): zio.aws.location.model.LteLocalId.ReadOnly = new Wrapper(impl)
}
