package zio.aws.location.model
import zio.aws.location.model.primitives.{Earfcn, Rsrq, Pci, EutranCellId, Rsrp}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LteNetworkMeasurements(
    earfcn: Earfcn,
    cellId: EutranCellId,
    pci: Pci,
    rsrp: Optional[Rsrp] = Optional.Absent,
    rsrq: Optional[Rsrq] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.LteNetworkMeasurements = {
    import LteNetworkMeasurements.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.LteNetworkMeasurements
      .builder()
      .earfcn(Earfcn.unwrap(earfcn): Integer)
      .cellId(EutranCellId.unwrap(cellId): Integer)
      .pci(Pci.unwrap(pci): Integer)
      .optionallyWith(rsrp.map(value => Rsrp.unwrap(value): Integer))(_.rsrp)
      .optionallyWith(rsrq.map(value => Rsrq.unwrap(value): java.lang.Float))(
        _.rsrq
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.LteNetworkMeasurements.ReadOnly =
    zio.aws.location.model.LteNetworkMeasurements.wrap(buildAwsValue())
}
object LteNetworkMeasurements {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.LteNetworkMeasurements
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.LteNetworkMeasurements =
      zio.aws.location.model.LteNetworkMeasurements(
        earfcn,
        cellId,
        pci,
        rsrp.map(value => value),
        rsrq.map(value => value)
      )
    def earfcn: Earfcn
    def cellId: EutranCellId
    def pci: Pci
    def rsrp: Optional[Rsrp]
    def rsrq: Optional[Rsrq]
    def getEarfcn: ZIO[Any, Nothing, Earfcn] = ZIO.succeed(earfcn)
    def getCellId: ZIO[Any, Nothing, EutranCellId] = ZIO.succeed(cellId)
    def getPci: ZIO[Any, Nothing, Pci] = ZIO.succeed(pci)
    def getRsrp: ZIO[Any, AwsError, Rsrp] =
      AwsError.unwrapOptionField("rsrp", rsrp)
    def getRsrq: ZIO[Any, AwsError, Rsrq] =
      AwsError.unwrapOptionField("rsrq", rsrq)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.LteNetworkMeasurements
  ) extends zio.aws.location.model.LteNetworkMeasurements.ReadOnly {
    override val earfcn: Earfcn =
      zio.aws.location.model.primitives.Earfcn(impl.earfcn())
    override val cellId: EutranCellId =
      zio.aws.location.model.primitives.EutranCellId(impl.cellId())
    override val pci: Pci = zio.aws.location.model.primitives.Pci(impl.pci())
    override val rsrp: Optional[Rsrp] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrp())
      .map(value => zio.aws.location.model.primitives.Rsrp(value))
    override val rsrq: Optional[Rsrq] = zio.aws.core.internal
      .optionalFromNullable(impl.rsrq())
      .map(value => zio.aws.location.model.primitives.Rsrq(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.LteNetworkMeasurements
  ): zio.aws.location.model.LteNetworkMeasurements.ReadOnly = new Wrapper(impl)
}
